--[[
only use ActionItems.lua
sGridNo - get gridno number 
]]


Profil = {
	ELDIN = 127,
}

Team = {
	OUR_TEAM = 0,
	ENEMY_TEAM = 1,
	CREATURE_TEAM = 2,
	MILITIA_TEAM = 3,	
	CIV_TEAM = 4,	
	PLAYER_PLAN	= 5,
	LAN_TEAM_ONE = 6,
	LAN_TEAM_TWO = 7,
	LAN_TEAM_THREE = 8,
	LAN_TEAM_FOUR = 9,
}

StatusAlert = {
	STATUS_GREEN = 0,
	STATUS_YELLOW = 1,		
	STATUS_RED = 2,	
	STATUS_BLACK = 3,		
}

ActionType = {
	AI_ACTION_GET_CLOSER = 5,
}

Facts = {
	FACT_MUSEUM_ALARM_WENT_OFF = 278,
}

SoundVolume = {
	LOWVOLUME	=	25,
	BTNVOLUME	=	40,
	MIDVOLUME	=	65,
	HIGHVOLUME	=	127,
}

Sample = {
	KLAXON_ALARM = 214,
}

Group = {

	NON_CIV_GROUP = 0,
	REBEL_CIV_GROUP = 1,
	KINGPIN_CIV_GROUP = 2,
	SANMONA_ARMS_GROUP = 3,
	ANGELS_GROUP = 4,
	BEGGARS_CIV_GROUP = 5,
	TOURISTS_CIV_GROUP = 6,
	ALMA_MILITARY_CIV_GROUP = 7,
	DOCTORS_CIV_GROUP = 8,
	COUPLE1_CIV_GROUP = 9,
	HICKS_CIV_GROUP = 10,
	WARDEN_CIV_GROUP = 11,
	JUNKYARD_CIV_GROUP = 12,
	FACTORY_KIDS_GROUP = 13,
	QUEENS_CIV_GROUP = 14,
}

Civ_status = {
	CIV_GROUP_NEUTRAL = 0,
	CIV_GROUP_WILL_EVENTUALLY_BECOME_HOSTILE = 1,
	CIV_GROUP_WILL_BECOME_HOSTILE = 2,
	CIV_GROUP_HOSTILE = 3,
}

Noise = {
	NOISE_UNKNOWN = 0,
	NOISE_MOVEMENT = 1,
	NOISE_CREAKING = 2,
	NOISE_SPLASHING = 3,
	NOISE_BULLET_IMPACT = 4,
	NOISE_GUNFIRE = 5,
	NOISE_EXPLOSION = 6,
	NOISE_SCREAM = 7,
	NOISE_ROCK_IMPACT = 8,
	NOISE_GRENADE_IMPACT = 9,
	NOISE_WINDOW_SMASHING = 10,
	NOISE_DOOR_SMASHING = 11,
	NOISE_SILENT_ALARM = 12, 
}

local ubProfil = 0
local MAX_MISC_NOISE_DURATION = 12
local iLoop
local NOBODY = 254
local LAST_TEAM = Team.LAN_TEAM_FOUR
local bTeam

function PerformItemAction()

if Action == 1 then
	ACTION_ITEM_OPEN_DOOR (sGridNo)
end

if Action == 2 then
	ACTION_ITEM_CLOSE_DOOR (sGridNo)
end

if Action == 3 then

end

if Action == 4 then
	Add3X3Pit (sGridNo)
	SearchForOtherMembersWithinPitRadiusAndMakeThemFall ( sGridNo, 1 )
end

if Action == 5 then
	Add5X5Pit (sGridNo)
	SearchForOtherMembersWithinPitRadiusAndMakeThemFall ( sGridNo, 2 )
end

if Action == 6 then
	ACTION_ITEM_TOGGLE_DOOR (sGridNo)
end

if Action == 7 then
	ToggleActionItemsByFrequency( 1 )
end

if Action == 8 then
	ToggleActionItemsByFrequency ( 2 )
end

if Action == 9 then
	ToggleActionItemsByFrequency( 3 )
end

if Action == 10 then
	ToggleActionItemsByFrequency( 4 )
end

if Action == 11 then
	--ACTION_ITEM_ENTER_BROTHEL (sGridNo)
end

if Action == 12 then
	--ACTION_ITEM_EXIT_BROTHEL (sGridNo)
end

if Action == 13 then

	PlayJA2Sample( Sample.KLAXON_ALARM, SoundVolume.MIDVOLUME, sGridNo )
	
	if ( TacticalStatusTeamActive(Team.CIV_TEAM) == true ) then
	
		SetPublicNoiseGridNo( Team.CIV_TEAM, sGridNo )
		SetPublicNoiseVolume( Team.CIV_TEAM, MAX_MISC_NOISE_DURATION )
	
		for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
			if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop,Group.KINGPIN_CIV_GROUP) == true ) then
				  SetNewSituationMercPtrs ( iLoop )
			end
		end
	end	
		
		SetCivGroupHostile( Group.KINGPIN_CIV_GROUP , Civ_status.CIV_GROUP_HOSTILE )
		
		for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
			if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop,Group.KINGPIN_CIV_GROUP) == true ) then
				for aimLoop=GetTacticalStatusFirstID(Team.OUR_TEAM),GetTacticalStatusLastID(Team.OUR_TEAM) do
					if (CheckMercPtrsID1SeenID2(iLoop,aimLoop) == true) then
						MakeMercPtrsHostile( iLoop )
					end
				end	
			end	
		end
 
	if ( CheckCombatMode == false ) then
		EnterTeamCombatMode(Team.CIV_TEAM)
	end	
	
end

if Action == 14 then
	--ACTION_ITEM_SEX ()
end

if Action == 15 then
	ACTION_ITEM_REVEAL_ROOM (sGridNo)
end

if Action == 16 then
	MakeNoise( NOBODY, sGridNo, 0, WorldLevelDataTerrainID(sGridNo), 30, Noise.NOISE_SILENT_ALARM );
end

if Action == 17 then

	for i = 0 , LAST_TEAM do
		if ( TacticalStatusTeamActive(i) == true ) then
			if ( TacticalStatusTeamHuman(i) == false and ( not i == Team.CIV_TEAM ) ) then
				
				SetPublicNoiseGridNo( i, sGridNo )
				SetPublicNoiseVolume( i, MAX_MISC_NOISE_DURATION )
				
				iLoop = GetTacticalStatusFirstID(i)
				for o = iLoop,GetTacticalStatusLastID(iLoop) do
					if ( CheckMercPtrsInSector (o) == true and CheckMercPtrsInActive(o) == true ) then
						SetNewSituationMercPtrs( o )
						WearGasMaskIfAvailable( o )			
					end
				end
			end
		end
	end
	
end

if Action == 18 then
	PlayJA2Sample( Sample.KLAXON_ALARM, SoundVolume.MIDVOLUME, sGridNo )
end

if Action == 19 then
	ACTION_ITEM_UNLOCK_DOOR (sGridNo)
end

if Action == 20 then
	ACTION_ITEM_TOGGLE_LOCK (sGridNo)
end

if Action == 21 then
	ACTION_ITEM_UNTRAP_DOOR (sGridNo)
end

if Action == 22 then
	TogglePressureActionItemsInGridNo (sGridNo)
end

if Action == 23 then

	ubProfil = Profil.ELDIN
	
	PlayJA2Sample( Sample.KLAXON_ALARM, SoundVolume.MIDVOLUME, sGridNo )
	
	-- Eldin becomes aware of a very important "noise" coming from here!
	-- So long as he hasn't already heard a noise a sec ago...
	if ( TacticalStatusTeamActive(Team.CIV_TEAM) == true ) then
		-- new situation for Eldin
		if ( CheckSoldierInSector(ubProfil) == true and CheckSoldierActive(ubProfil) == true and CheckNPCLife(ubProfil) > 0 and ( CheckSoldierAlertStatus(ubProfil) == StatusAlert.STATUS_GREEN and CheckSoldierNoiseVolume(ubProfil) ==  6  ) ) then
				if ( SoldierTo3DLocationLineOfSightTest( ubProfil, sGridNo, 0, 0 ) == true ) then
					
					-- sees the player now!
					TriggerNPCWithIHateYouQuote(ubProfil)
					SetNewSituation(ubProfil)
				else
					SetNoiseGridno(ubProfil,sGridNo)
					SetNoiseVolume(ubProfil,6)
					SetAlertStatus(ubProfil,StatusAlert.STATUS_GREEN)
					if  ( not CheckAction(ubProfil) == ActionType.AI_ACTION_GET_CLOSER  ) or CheckFact (Facts.FACT_MUSEUM_ALARM_WENT_OFF) == false then
						CancelAIAction( ubProfil)
						SetNextAction(ubProfil , ActionType.AI_ACTION_GET_CLOSER )
						SetNextActionData(ubProfil , sGridNo)
						RESETTIMECOUNTER( ubProfil, 100 )
					end
				end
			SetFactTrue( Facts.FACT_MUSEUM_ALARM_WENT_OFF )
		end
	end
	
	
end

if Action == 24 then
	bTeam = Team.CREATURE_TEAM

		if ( TacticalStatusTeamActive(bTeam) == true ) then
			if ( TacticalStatusTeamHuman(bTeam) == false and ( not bTeam == Team.CIV_TEAM ) ) then
				
				SetPublicNoiseGridNo( bTeam, sGridNo )
				SetPublicNoiseVolume( bTeam, MAX_MISC_NOISE_DURATION )
				
				iLoop = GetTacticalStatusFirstID(bTeam)
				for o = iLoop,GetTacticalStatusLastID(bTeam) do
					if ( CheckMercPtrsInSector (o) == true and CheckMercPtrsInActive(o) == true ) then
						SetNewSituationMercPtrs( o )
						WearGasMaskIfAvailable( o )			
					end
				end
			end
		end
end

if Action == 25 then
	if ( CheckGlobalBool(55) == false ) then
      
		ApplyMapChangesToMapTempFile(true)
		RemoveStruct (88,4,8080)	
		ApplyMapChangesToMapTempFile(false)	
		SetRender()	
		ConvertGridNoToXY(8080,7)	
		SetGlobalTrue (55)	
		SetMoneyInSoldierProfile (3 , 33333)
   
	end	
end

end
